<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Projects extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable = [
        'title',
        'code',
        'product_category_id',
        'project_type_id',
        'department_id',
        'receive_date',
        'start_date',
        'dead_line_date',
        'about',
        'priority',
        'status',
        'last_voucher_count',
    ];
    public function getProjectType()
    {
        return $this->belongsTo(ProjectType::class,'project_type_id');
    }
    public function getProductCategory()
    {
        return $this->belongsTo(ProductCategory::class,'product_category_id');
    }
    public function getDepartments()
    {
        return $this->belongsToMany(OrganizationDepartment::class, 'project_departments', 'project_id', 'department_id');
    }

}
