<?php

namespace App\Models\Purchase;

use App\Models\Product;
use App\Models\ProductPrice;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PurchaseInvoiceDetails extends Model
{
    use HasFactory,SoftDeletes;
    protected $fillable = [
        'purchase_invoice_id',
        'product_id',
        'product_price_id',
        'item_batch',
        'main_qty',
        'alt_qty',
        'free_qty',
        'price',
        'basic_amount',
        'discount_percentage',
        'discount_amount',
        'tax_slab_id',
        'tax_calculation_type',
        'tax_cess_settings',
        'tax_cess_amount',
        'tax_special_cess_amount',
        'total_amount',
        'from_date_time',
        'to_date_time',
        'gross_weight',
        'net_weight',
        'charge_weight',
        'making_charge',
        'additional_cost',
        'other_charges',
        'godown_id',
        'item_details',
        'batch_id',
        'customer_amount',
        'tpa_amount'
    ];

    public function getProduct()
    {
        return $this->hasOne(Product::class,'id','product_id')->with('getProductPrice','getTaxMaster','getProductBrand');
    }

    static public function getItemWiseStatement($where = [], $filters = [])
    {
        $from_date         = $filters["from_date"] ?? '';
        $to_date           = $filters["to_date"] ?? '';
        $company           = $filters["company"] ?? '';
        $search_account    = $filters["search_account"] ?? '';
        $created_by        = $filters["created_by"] ?? '';
        $voucher_type_code = $filters["voucher_type_code"] ?? '';
        $brand_id          = $filters["brand_id"] ?? '';
        $group_id          = $filters["group_id"] ?? '';
        $category_id       = $filters["category_id"] ?? '';
        $division_id       = $filters["division_id"] ?? '';
        $product_id        = $filters["product_id"] ?? '';
        $doctor            = $filters["doctor_id"] ?? '';

        return self::leftJoin('purchase_invoices','purchase_invoice_details.purchase_invoice_id','purchase_invoices.id')
                ->leftJoin('tax_masters','purchase_invoice_details.tax_slab_id','tax_masters.id')
                ->leftjoin('products', 'purchase_invoice_details.product_id', 'products.id')
                ->leftjoin('product_categories', 'products.category_id', 'product_categories.id')
                ->leftjoin('purchase_invoice_batches', 'purchase_invoice_details.batch_id', 'purchase_invoice_batches.id')
                ->leftJoin('accounts as bill_to','purchase_invoices.bill_to_account_id','bill_to.id')
                ->leftJoin('accounts as doctor','purchase_invoices.doctor_id','doctor.id')
                ->leftjoin('accounts', 'accounts.id', 'purchase_invoices.patient_id')
                ->leftjoin('voucher_types', 'voucher_types.code', 'purchase_invoices.voucher_type_code')
                ->leftjoin('voucher_masters', 'voucher_types.voucher_master_id', 'voucher_masters.id')
                ->when(!empty($search_account), function($saleInvoices) use($search_account) {
                    $saleInvoices->where('accounts.id',  $search_account);
                })
                ->when(!empty($brand_id), function ($query) use ($brand_id) {
                    return $query->where('products.brand_id', $brand_id);
                })
                ->when(!empty($doctor), function ($query) use ($doctor) {
                    return $query->where('purchase_invoices.doctor_id', $doctor);
                })
                ->when(!empty($product_id), function ($query) use ($product_id) {
                    return $query->where('products.id', $product_id);
                })
                ->when(!empty($group_id), function ($query) use ($group_id) {
                    return $query->where('products.composition_id', $group_id);
                })
                ->when(!empty($division_id), function ($query) use ($division_id) {
                    return $query->where('products.business_division_id', $division_id);
                })
                ->when(!empty($category_id), function ($query) use ($category_id) {
                    return $query->where('products.category_id', $category_id);
                })
                ->when(!empty($voucher_type_code), function($saleInvoices) use($voucher_type_code) {
                    $saleInvoices->where('purchase_invoices.voucher_type_code', '=', $voucher_type_code);
                })
                ->when(!empty($created_by), function($saleInvoices) use($created_by) {
                    $saleInvoices->where('purchase_invoices.operator_id', '=', $created_by);
                })
                ->when(!empty($company), function($saleInvoices) use($company) {
                    $saleInvoices->where('purchase_invoices.company_id', '=', $company);
                })
                ->when(!empty($from_date) && !empty($to_date), function($query) use ($from_date, $to_date) {
                    $query->when($from_date == $to_date, function($query2) use ($from_date) {
                        $query2->whereDate('purchase_invoices.invoice_date', $from_date);
                    })
                    ->when($from_date != $to_date, function($query2) use ($from_date, $to_date) {
                        $query2->whereBetween('purchase_invoices.invoice_date', [$from_date, $to_date]);
                    });
                })
                ->select([
                    'purchase_invoices.id',
                    'purchase_invoices.invoice_date',
                    'purchase_invoices.main_invoice_no',
                    'purchase_invoices.voucher_type_invoice_no',
                    'purchase_invoices.supplier_invoice_number',
                    'purchase_invoices.patient_id',
                    'purchase_invoices.voucher_type_code',
                    'voucher_types.name as voucher_type_name',
                    'purchase_invoices.payment_mode_id',
                    'purchase_invoices.invoice_type',
                    'tax_masters.total_percentage as tax_percentage',
                    'purchase_invoice_details.product_id',
                    'purchase_invoice_details.batch_id',
                    'purchase_invoice_details.main_qty',
                    'purchase_invoice_details.alt_qty',
                    'purchase_invoice_details.basic_amount',
                    'purchase_invoice_details.tax_calculation_type',
                    'purchase_invoice_details.total_amount',
                    'products.name as product_name',
                    'products.shortcode',
                    'products.hsncode',
                    'accounts.name as account_name',
                    'product_categories.name as product_category',
                    'accounts.code as account_code',
                    'doctor.name as doctor_name',
                    'doctor.code as doctor_code',
                    'bill_to.name as bill_to_name',
                    'bill_to.code as bill_to_code',
                    'purchase_invoice_batches.invoice_batch_no',
                    'tax_masters.name as tax',
                    'voucher_masters.tax_calculation'
                ])
                ->groupBy('purchase_invoice_details.id')
                ->get();
    }
   
    public function getProductPrice()
    {
        return $this->hasOne(ProductPrice::class,'id','product_price_id')->select('exp_date');
    }
}
