<?php

namespace App\Models\Purchase;

use App\Models\Account;
use App\Models\AccountingGroup;
use App\Models\Company;
use App\Models\PaymentMode;
use App\Models\User;
use App\Models\VoucherType;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class PurchaseInvoices extends Model
{
    use HasFactory,SoftDeletes;
    protected $fillable = [
        'main_invoice_no',
        'branch_invoice_no',
        'voucher_type_invoice_no',
        'invoice_date',
        'voucher_type_code',
        'voucher_type_id',
        'patient_id',
        'doctor_id',
        'collection_agent_id',
        'refferal_lab_id',
        'reff_no',
        'payment_term_id',
        'order_date',
        'remarks',
        'broker_id',
        'operator_id',
        'company_id',
        'status',
        'financial_year_id',
        'industry_type_id',
        'dispatch_from_id',
        'ship_to_id',
        'tracking_id',
        'special_case_id',
        'last_voucher_count',
        'bussiness_source_id',
        'payment_mode_id',
        'last_voucher_type_count',
        'invoice_type',
        'transaction_mode_id',
        'updated_by',
        'deleted_by',
        'bill_to_account_id',
        'tpa_corporate_id',
        'last_branch_count',
        'supplier_invoice_number'
    ];



    public function getPurchaseInvoiceDetail()
    {
        return $this->hasMany(PurchaseInvoiceDetails::class,'purchase_invoice_id','id');
    }

    public function getPurchaseInvoiceDetailWithProductTestPackage()
    {
        return $this->hasMany(PurchaseInvoiceDetails::class)->with('getProductTestPackage','getProduct');
    }

    public function getPurchaseInvoiceDetails()
    {
        return $this->hasMany(PurchaseInvoiceDetails::class,'purchase_invoice_id','id');
    }

    public function getPurchaseInvoiceDiscounts()
    {
        return $this->hasOne(PurchaseInvoiceDetails::class,'purchase_invoice_id','id')->select(['purchase_invoice_id','batch_id',DB::raw('SUM(discount_amount) as discount_amount')])->groupBy('purchase_invoice_id');;
    }


    public function getPatient()
    {
        return $this->hasOne(Account::class, 'id', 'patient_id')->with('first_account_address','account_contact', 'account_title');
    }

    public function getDoctor()
    {
        return $this->hasOne(Account::class, 'id', 'doctor_id')->with('first_account_address','account_contact', 'account_title');
    }

    public function getCollectionAgent()
    {
        return $this->hasOne(Account::class, 'id', 'collection_agent_id')->with('first_account_address','account_contact');
    }

    public function getRefferalLab()
    {
        return $this->hasOne(Account::class, 'id', 'refferal_lab_id')->with('first_account_address','account_contact');
    }

    public function getOperator()
    {
        return $this->hasOne(User::class, 'id', 'operator_id');
    }

    public function getAccountGroup()
    {
       return $this->belongsTo(AccountingGroup::class,'transaction_mode_id');
    }

    public function getPaymentMode()
    {
       return $this->belongsTo(PaymentMode::class,'payment_mode_id');
    }

    
    public function getCompany()
    {
       return $this->belongsTo(Company::class,'company_id')->with('getCompanyAddress')->with('getCompanybank');
    }

    public function getVoucherType()
    {
       return $this->belongsTo(VoucherType::class,'code','voucher_type_code');
    }

    public function getCustomer()
    {
        return $this->hasOne(Account::class, 'id', 'patient_id')->with('first_account_address','account_contact', 'account_title');
    }

    public function user(){
        return $this->hasOne(User::class,'id','created_by');
    }

    public function accountSaleReceiptTransaction(){
        return $this->hasOne(User::class,'id','created_by');
    }

    
    public function getCreatedBy()
    {
       return $this->hasOne(User::class,'id','operator_id')->select(['id','name','prepared_by']);
    }

    public function getVoucher()
    {
        return $this->hasOne(VoucherType::class,'code','voucher_type_code')->with('voucherTerm');
    }

    public function getBatchs()
    {
        return $this->hasMany(PurchaseInvoiceBatches::class, 'purchase_invoice_id', 'id');
    }

    public function getBatch()
    {
        return $this->hasOne(PurchaseInvoiceBatches::class, 'purchase_invoice_id', 'id');
    }
}
