<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RackLocation extends Model
{
    use HasFactory;
    protected $fillable = [
        'room_id',
        'row_number',
        'column_number',
        'priority',
        'status',
        'default'
    ];

    public function getRoom()
    {
        return $this->belongsTo(Room::class, 'room_id');
    }
}
