<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ReferralVoucher extends Model
{
    use HasFactory,SoftDeletes;

    protected $fillable = [
		'incentive_date',
		'month',
		'year',
		'from_date',
		'to_date',
		'consultant_id',
		'financial_year_id',
		'voucher_no',
		'voucher_type_code',
		'payment_status',
		'incentive_slab_id',
		'created_by',
		'updated_by',
		'last_voucher_type_count'
	];

    public function getDetail()
    {
    	return $this->hasOne(ReferralVoucherDetail::class);
    }
}
