<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Room extends Model
{
    use HasFactory;

    protected $fillable = [
        'room_number',
        'room_name',
        'room_code',
        'building_id',
        'floor_id',
        'status',
        'priority',
        'default'
    ];
    public function getBuilding()
    {
        return $this->belongsTo(Building::class,'building_id');
    }
    public function getFloor()
    {
        return $this->belongsTo(Floor::class,'floor_id');
    }
}
