<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SaleInvoiceBatch extends Model
{
    use HasFactory,SoftDeletes;

    protected $fillable = [
        'invoice_id',
        'account_id',
        'invoice_batch_date',
        'invoice_batch_no',
        'incentive',
        'last_voucher_count',
        'remarks_for_technician',
        'sample_receive_date',
        'sample_receive_time',
        'sample_barcode',
        'created_by',
        'updated_by',
        'consultant_id',
        'referrence_voucher_type',
        'referrence_voucher_id',
        'batch_status'
    ];

    public function getSaleInvoice()
    {
        return $this->hasOne(SaleInvoice::class,'id','invoice_id')
        ->where('voucher_type_code', 'IPD_ADMISSION');
    }

    public function getSaleInvoiceDetails()
    {
        return $this->hasMany(SaleInvoiceDetail::class,'batch_id','id');
    }

    public function getConsultant()
    {
        return $this->hasOne(Account::class, 'id', 'consultant_id')->with('first_account_address','account_contact', 'account_title');
    }
    public function voucherType()
    {
        return $this->hasOne(VoucherType::class,'code','referrence_voucher_type')->select('code','name')->where('status',1);
    }

}
