<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SaleInvoiceSubDetails extends Model
{
    use HasFactory;

    protected $fillable = [
        'sale_invoice_detail_id',
        'sale_invoice_id',
        'data_referrence_id', // testpackage_id
        'subdetails_remarks',
        'referrence_type',
        'status',
        'task_status_id',
        'task_created_by_id',
    ];

    public function getCreatedBy()
    {
        return $this->belongsTo(User::class,'task_created_by_id');
    }

    public function getEditedBy()
    {
        return $this->belongsTo(User::class,'task_edited_by_id');
    }

    public function getReviewedBy()
    {
        return $this->belongsTo(User::class,'task_reviewed_by_id');
    }

    public function getTestPackage()
    {
        return $this->hasOne(TestPackage::class,'id','data_referrence_id');
    }

    public function tracking()
    {
        return $this->hasMany(SaleInvoiceTaskTracking::class,'sale_invoice_sub_details_id')->with('user');
    }

    public function trackCreatedAt()
    {
        return $this->hasOne(SaleInvoiceTaskTracking::class,'sale_invoice_sub_details_id')->where('tracking_type', 'Created');
    }
}
