<?php

namespace App\Models;

use App\Models\Purchase\PurchaseInvoices;
use App\Models\Sales\SaleReturns;
use App\Models\Stocks\StockIn;
use App\Models\Stocks\StockMomentType;
use App\Models\Stocks\StockOut;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Stock extends Model
{
    use HasFactory,SoftDeletes;

    protected $primaryKey = "id";
    protected $fillable = ['voucher_id',
                            'voucher_type',
                            'entry_date',
                            'stock_type',
                            'product_id',
                            'batch_id',
                            'attribute_id',
                            'rack_location_id',
                            'pack_qty_in',
                            'loose_qty_in',
                            'pack_qty_out',
                            'loose_qty_out',
                            'taxable_unit_price',
                            'created_by_user_id',
                            'updated_by_user_id',
                            'company_id',
                            'financial_year_id',
                            'status',
                            'invoice_batch_id',
                            'warehouse_id',
                            'free_qty'
                        ];
    public function getProduct()
    {
        return $this->hasOne(Product::class, 'id', 'product_id');
    }

    public function voucherSaleType()
    {
        return $this->hasOne(SaleInvoice::class,'id','voucher_id');
    }
    public function voucherPurchaseType()
    {
        return $this->hasOne(PurchaseInvoices::class,'id','voucher_id');
    }
    public function voucherReturnType()
    {
        return $this->hasOne(SaleReturns::class,'id','voucher_id');
    }
    public function voucherStockIn()
    {
        return $this->hasOne(StockIn::class,'id','voucher_id');
    }
    public function voucherStockOut()
    {
        return $this->hasOne(StockOut::class,'id','voucher_id');
    }

    public function getCreatedBy()
    {
       return $this->hasOne(User::class,'id','created_by_user_id')->select(['id','name','prepared_by']);
    }

    public function getMovementType()
    {
       return $this->hasOne(StockMomentType::class,'code','stock_type')->select(['code','name']);
    }
}
