<?php

namespace App\Models\Stocks;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StockMomentType extends Model
{
    use HasFactory,SoftDeletes;

    protected $primaryKey = "id";
    protected $fillable = [ 'name',
                            'code',
                            'calculation_type',
                            'description',
                            'priority',
                            'status',
                        ];

    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }
}
