<?php

namespace App\Models\Stocks;

use App\Models\Product;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StockOutDetail extends Model
{
    use HasFactory,SoftDeletes;
    protected $fillable = [
        'invoice_id',
        'product_id',
        'product_price_id',
        'item_batch',
        'main_qty',
        'alt_qty',
        'free_qty',
        'price',
        'basic_amount',
        'discount_percentage',
        'discount_amount',
        'tax_slab_id',
        'tax_calculation_type',
        'tax_cess_settings',
        'tax_cess_amount',
        'tax_special_cess_amount',
        'total_amount',
        'from_date_time',
        'to_date_time',
        'gross_weight',
        'net_weight',
        'charge_weight',
        'making_charge',
        'additional_cost',
        'other_charges',
        'godown_id',
        'item_details',
        'batch_id',
        'customer_amount',
        'tpa_amount'
    ];

    public function getProduct()
    {
        return $this->hasOne(Product::class,'id','product_id')->with('getProductPrice','getTaxMaster','getProductBrand');
    }
}
