<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Surgery extends Model
{
    use HasFactory;

    protected $fillable = [
        'ipd_id',
        'surgent_ac_id',
        'surgery_type_id',
        'notes',
        'scheduled_date_time',
        'duration',
        'surgery_done_at',
        'surgery_feedback',
        'status',
        'anesthesia_name',
        'anesthesia_type',
        'anesthesia_doctor',
        'anesthesia_quantity',
        'anesthesia_form',
        'anesthesia_time',
    ];

    public function getDoctor()
    {
        return $this->belongsTo(Account::class,'anesthesia_doctor');
    }
}
