<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Task extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable = [
        'account_id',
        'project_id',
        'task_type_id',
        'title',
        'details',
        'date',
        'chargable',
        'cost',
        'sale_price',
        'status',
        'task_point',
        'task_status_id',
        'task_priority_id',
        'amount',
        'deadline',
        'completion_date',
        'task_group_id',
        'pipeline_stage_id',
        'progress',
        'privacy_type',
        'estimated_time',
        'actual_time',
        'payment_status',
        'created_by',
        'updated_by',
        'deleted_by',
    ];
    public function getAccount()
    {
        return $this->belongsTo(Account::class,'account_id','id');
    }

    public function getProject()
    {
        return $this->belongsTo(Projects::class,'project_id');
    }

    public function getTaskType()
    {
        return $this->belongsTo(TaskType::class,'task_type_id');
    }

    public function taskTracking()
    {
        return $this->hasMany(TaskTracking::class);
    }

    public function taskStatus()
    {
        return $this->belongsTo(PipelineStage::class,'task_status_id');
    }
}
