<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TaskAttachment extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable = [
        'title',
        'task_id', 
        'created_by',
        'uploaded_file',
        'status',
    ];
    public function getTask()
    {
        return $this->belongsTo(Task::class,'task_id');
    }

}
