<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TaskEntry extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'responsible_teams';
    protected $fillable = [
        'task_id',
        'assigned_by_id',
        'assigned_to_id',
        'assigned_date',
        'expected_completion_date',
        'actual_completion_date',
        'status',
        'responsibility',
        'task_accepted_status',
        'reject_reason',
        'is_main',
    ];
    public function getAssignTo()
    {
        return $this->belongsTo(User::class,'assigned_to_id');
    }
}
