<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TaskTracking extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable = [
        'task_status_id',
        'task_priority_id',
        'assign_to',
        'task_id',
        'status',
    ];

    public function getAssignTo()
    {
        return $this->belongsTo(User::class,'assign_to');
    }
    public function getTaskStatus()
    {
        return $this->belongsTo(TaskStatus::class,'task_status_id');
    }
    public function getTaskPriority()
    {
        return $this->belongsTo(TaskPriority::class,'task_priority_id');
    }
    public function getTasks()
    {
        return $this->belongsTo(Task::class,'task_id');
    }
}
