<?php

namespace App\Models;

use App\Models\Scopes\GlobalStatusScope;
use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TaxCategory extends Model
{
    use HasFactory;
    protected $fillable = [
        'name',
        'code',
        'description',
        'priority',
        'status',
        'default'
    ];
    protected static function boot()
    {
        parent::boot();

        static::addGlobalScope(new GlobalStatusScope());
    }
}
