<?php

namespace App\Models;

use App\Models\Scopes\GlobalStatusScope;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TaxMaster extends Model
{
    use HasFactory;

    protected $fillable = [
        'account_id',
        'name',
        'description',
        'total_percentage',
        'calculation',
        'tax_category_id',
        'priority',
        'default',
        'status',
        'code'
    ];
    public function getTaxCategory()
    {
        return $this->belongsTo(TaxCategory::class,'tax_category_id');
    }
    public function getTaxMasterSub()
    {
        return $this->hasMany(TaxMasterSub::class);
    }
    public function getAccount()
    {
        return $this->belongsTo(Account::class,'account_id');
    }
}
