<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TestItem extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $guarded = [];

    public function primary_unit()
    {
        return $this->belongsTo(PrimaryUnit::class);
    }

    public function package_test_item_mapping()
    {
        return $this->hasOne(PackageTestItemMapping::class);
    }

    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    public function test_method()
    {
        return $this->belongsTo(TestMethod::class);
    }

    public function testItemNormalRange()
    {
        return $this->hasMany(TestItemNormalRange::class)->with('gender');
    }

    public function testItemOption()
    {
        return $this->hasMany(TestItemOption::class)->with('styleType');
    }

    public function testItemTemplates()
    {
        return $this->hasMany(TestItemTemplate::class);
    }
}
