<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TestPackage extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $guarded = [];

    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    public function package_notes()
    {
        return $this->hasMany(TestPackageNote::class)->orderBy('priority', 'ASC');
    }

    public function package_note()
    {
        return $this->hasOne(TestPackageNote::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function testPackageGroups()
    {
        return $this->hasMany(TestPackageGroup::class,'test_package_id','id');
    }
}
