<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TestPackageGroup extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $guarded = [];

    public function test_package_group_test_items()
    {
        return $this->hasMany(TestPackageGroupTestItem::class)->orderBy('priority', 'ASC')->with('test_item');
    }

    public function test_package_group_notes()
    {
        return $this->hasMany(TestPackageGroupNote::class, 'test_package_group_id')->orderBy('priority', 'ASC');
    }

    public function testPackage()
    {
        return $this->belongsTo(TestPackage::class);
    }
}
