<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TestPackageGroupTestItem extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $guarded = [];

    public function test_package_group()
    {
        return $this->belongsTo(TestPackageGroup::class);
    }

    public function testPackageItems()
    {
        return $this->hasMany(TestItem::class,'id','test_item_id');
    }

    public function test_item()
    {
        return $this->hasOne(TestItem::class, 'id', 'test_item_id')
        ->select([
            'test_items.id',
            'test_items.name as test_name',
            'test_items.item_type',
            'test_items.code as test_code',
            'test_items.input_type',
            'test_items.reference_value_type',
            'test_items.reference_value',
            'test_methods.name as test_method_name',
            'test_items.is_read_only',
            'test_items.formula_code',
            'test_items.status',
            'test_items.title_style',
            'test_units.name as unit',
        ])
        ->leftjoin('test_units', 'test_items.primary_unit_id', 'test_units.id')
        ->leftjoin('test_methods', 'test_methods.id', 'test_items.test_method_id')
        ->with('testItemNormalRange','testItemOption');
    }
}
