<?php
namespace App\Models;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
// sanctum
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable,HasRoles;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'is_super_admin',
        'username',
        'password',
        'company_id',
        'user_signature',
        'user_designation',
        'user_image',
        'prepared_by',
        'status',
        'phone_no',
        'whatsapp_no',
        'account_id',
        'user_type'
    ];

    protected $appends = ['company_name'];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];
    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function getComapnyDetails()
    {
          return $this->hasOne(Company::class,'id','company_id');
    }

    public function getCompanyNameAttribute()
    {
        if ($this->company_id != '') {
            $company = Company::select('name')->find($this->company_id );

            return $company->name ?? '';
        }

        return '';
    }
    public function getAccount()
    {
        return $this->belongsTo(Account::class,'account_id','id');
    }
}
