<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VoucherMaster extends Model
{
    use HasFactory;

    protected $fillable = [
        'voucher_name',
        'voucher_code',
        'serial_no_format',
        'status',
        'decimal_length',
        'tax_calculation',
    ];

    public function voucherType()
    {
        return $this->hasOne(VoucherType::class)->with('voucherSeries');
    }

    public function voucherSeries()
    {
        return $this->hasOne(VoucherSeries::class);
    }

    public function voucherAllType()
    {
        return $this->hasMany(VoucherType::class)->select(['id','voucher_master_id','name','code'])->where('status',1);
    }
}
