<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VoucherSeries extends Model
{
    use HasFactory;

    protected $fillable = [
        'length',
        'prefix',
        'postfix',
        'separator',
        'frequency',
        'start_from',
        'series_name',
        'voucher_master_id',
        'voucher_type_id',
    ];

    public function voucherType()
    {
        return $this->belongsTo(VoucherType::class,'voucher_type_id');
    }

    public function voucherMaster()
    {
        return $this->belongsTo(VoucherMaster::class,'voucher_master_id');
    }
}
