<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VoucherType extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'code',
        'status',
        'priority',
        'is_default',
        'voucher_master_id',
        'voucher_title',
        'page_title',
        'tax_applicable',
        'letter_head_id',
        'show_hsn',
        'default_price_type'
    ];

    public function voucherMaster()
    {
        return $this->belongsTo(VoucherMaster::class,'voucher_master_id');
    }

    public function voucherSeries()
    {
        return $this->hasOne(VoucherSeries::class);
    }
    public function voucherTerm(){
        return $this->hasOne(VoucherTerm::class,'voucher_id','voucher_master_id')->where('status', '1')->orderBy('is_default','Desc');
    }
    public function voucherTypeTerm(){
        return $this->hasOne(VoucherTypeTerm::class,'voucher_id','id')->where('status', '1')->orderBy('is_default','Desc');
    }
}
