<?php

namespace App\Models\Website;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Branch extends Model
{
    use HasFactory;
    protected $table = 'branches';
    protected $fillable = [
        'title',
        'branch_type_id',
        'address',
        'email',
        'phone',
        'google_map',
        'cover_image',
        'priority',
        'status',
        'company_id',
    ];

    public function getBranchType()
    {
        return $this->hasOne(BranchType::class,'id','branch_type_id')->select(['name','id']);
    }
}
