<?php

namespace App\Models\Website;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ContentSubCategory extends Model
{
    use HasFactory;
    protected $table="content_sub_category";
    protected $fillable = [
        'category_id',
        'sub_category_name',
        'priority_status',
        'status',
    ];
    public function getCategory()
    {
        return $this->hasOne(PublicContentCategory::class,'id','category_id')->select(['name','id']);
    }
}
