<?php

namespace App\Models\Website;

use App\Models\NoticeType;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Notice extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $fillable = [
        'user_id',
        'page_id',
        'notice_type_id',
        'notice_title',
        'description',
        'start_date',
        'expiry_date',
        'notice_file',
        'page_url',
        'is_flash_notice',
        'new_flag',
        'priority',
        'status',
        'course_id'
    ];

    public function getUser()
    {
        return $this->belongsTo(User::class,'user_id');
    }
    public function getPage()
    {
        return $this->belongsTo(Post::class,'page_id');
    }

    public function getNoticeType()
    {
        return $this->belongsTo(NoticeType::class,'notice_type_id');
    }

}
