<?php

namespace App\Models\Website;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PageContent extends Model
{
    use HasFactory;

    protected $fillable = [
        'page_id',
        'content_type',
        'content_title',
        'content_details',
        'content_data',
        'content_id',
        'priority',
        'status'
    ];

    public function getContentCategory()
    {
        return $this->hasOne(PublicContentCategory::class,'id','content_id');
    }

    public function getGallery()
    {
        return $this->hasOne(TblPhotoGallery::class,'id','content_id');
    }

    public function getVideoGallery()
    {
        return $this->hasOne(TblVideoGallery::class,'id','content_id');
    }

}
