<?php

namespace App\Models\Website;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class Post extends Model
{
    use HasFactory;
   

    protected $table = 'posts';

    protected $guarded = [];
    
    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }

    protected $fillable = [
        'user_id',
        'title',
        'category_id',
        'brand_id',
        'image',
        'description',
        'body',
        'feature_image',
        'slug',
        'post_type',
        'meta_title',
        'meta_key',
        'meta_url',
        'meta_image',
        'company_id',
        'meta_description',
        'view_count',
        'video_url',
        'status',
    ];
}