<?php

namespace App\Models\Website;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PublicContent extends Model
{
    use HasFactory;
    protected $fillable = [
        'public_content_category_id',
        'company_id',
        'sub_category_id',
        'title',
        'description',
        'link',
        'files',
        'prority_status',
        'new_tag',
        'status',
        'pdf_file',
    ];

    public function getsubCategory()
    {
        return $this->hasOne(ContentSubCategory::class,'id','sub_category_id')->select(['sub_category_name','id']);
    }
    public function getCategory()
    {
        return $this->hasOne(PublicContentCategory::class,'id','public_content_category_id')->select(['name','id']);
    }
}
