<?php

namespace App\Models\Website;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TblPhotoGallery extends Model
{
    use HasFactory;
    protected $table="tbl_photo_gallery";
    protected $primaryKey = "id";
    protected $fillable = ['title',
                            'sub_title',
                            'details',
                            'gallery_keywords',
                            'company_id',
                            'cover_pic',
                            'gallery_type',
                            'date',
                            'priority',
                            'status',
                        ];
    public function getImagesAll()
    {
        return $this->hasMany(TblPhotoGalleryImage::class,'photo_gallery_id','id');
    }
}
