<?php

namespace App\Observers;

use App\Models\FinancialYear;

class FinancialYearObserver
{
    
    /**
     * Handle the FinancialYear "created" event.
     *
     * @param  \App\Models\FinancialYear  $financialyearmodel
     * @return void
     */
    public function creating(FinancialYear $financialyearmodel)
    {
        $financialyearmodel->financial_year_name = date('Y',strtotime($financialyearmodel->financial_year_start_date)).'-'.date('Y',strtotime($financialyearmodel->financial_year_end_date));
        $financialyearmodel->table_postfix = date('Y',strtotime($financialyearmodel->financial_year_start_date)).'_'.date('Y',strtotime($financialyearmodel->financial_year_end_date));
        $financialyearmodel->financial_year_short_code = date('y',strtotime($financialyearmodel->financial_year_start_date)).date('y',strtotime($financialyearmodel->financial_year_end_date));
        $financialyearmodel->status ='1';
    }
  
    /**
     * Handle the FinancialYear "created" event.
     *
     * @param  \App\Models\FinancialYear  $financialyearmodel
     * @return void
     */
    public function created(FinancialYear $financialyearmodel)
    {

    }
  
    /**
     * Handle the FinancialYear "updated" event.
     *
     * @param  \App\Models\FinancialYear  $financialyearmodel
     * @return void
     */
    public function updating(FinancialYear $financialyearmodel)
    {
        $financialyearmodel->financial_year_name = date('Y',strtotime($financialyearmodel->financial_year_start_date)).'-'.date('Y',strtotime($financialyearmodel->financial_year_end_date));
        $financialyearmodel->table_postfix = date('Y',strtotime($financialyearmodel->financial_year_start_date)).'_'.date('Y',strtotime($financialyearmodel->financial_year_end_date));
        $financialyearmodel->financial_year_short_code = date('y',strtotime($financialyearmodel->financial_year_start_date)).date('y',strtotime($financialyearmodel->financial_year_end_date));
        $financialyearmodel->status ='1';
    }
  
    /**
     * Handle the FinancialYear "deleted" event.
     *
     * @param  \App\Models\FinancialYear  $financialyearmodel
     * @return void
     */
    public function deleted(FinancialYear $financialyearmodel)
    {
          
    }
  
    /**
     * Handle the FinancialYear "restored" event.
     *
     * @param  \App\Models\FinancialYear  $financialyearmodel
     * @return void
     */
    public function restored(FinancialYear $financialyearmodel)
    {
          
    }
  
    /**
     * Handle the FinancialYear "force deleted" event.
     *
     * @param  \App\Models\FinancialYear  $financialyearmodel
     * @return void
     */
    public function forceDeleted(FinancialYear $financialyearmodel)
    {
          
    }
}
