<?php

namespace App\Providers;

use App\Models\AccountTransaction;
use App\Models\Purchase\PurchaseInvoices;
use App\Models\SaleInvoice;
use App\Models\Sales\SaleReturns;
use App\Models\Stocks\StockIn;
use App\Models\Stocks\StockOut;
use App\Observers\AccountTransactionObserver;
use App\Observers\PurchaseInvoiceObserver;
use App\Observers\SaleInvoiceObserver;
use App\Observers\SaleReturnObserver;
use App\Observers\StockInObserver;
use App\Observers\StockOutObserver;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Config;

class AppServiceProvider extends ServiceProvider
{
    protected static $hasRun = false;
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        view()->composer('*', function ($view) {
            if (!self::$hasRun) {
                if (auth()->check()) {
                    $authRolePermissions = \Session::get('rolePermissions');
                    $view->with('authRolePermissions', $authRolePermissions);

                    $modulePermissions = \Session::get('modulePermissions');
                    $view->with('modulePermissions', $modulePermissions);

                    $menuModules = \Session::get('menuModules');
                    $view->with('menuModules', $menuModules);

                    $leftMenuModules = \Session::get('leftMenuModules');
                    $view->with('leftMenuModules', $leftMenuModules);

                    $topMenuModules = \Session::get('topMenuModules');
                    $view->with('topMenuModules', $topMenuModules);

                    $quickMenuModules = \Session::get('quickMenuModules');
                    $view->with('quickMenuModules', $quickMenuModules);
                }

                self::$hasRun = true;
            }
        });

        SaleInvoice::observe(SaleInvoiceObserver::class);
        SaleReturns::observe(SaleReturnObserver::class);
        PurchaseInvoices::observe(PurchaseInvoiceObserver::class);
        StockIn::observe(StockInObserver::class);
        StockOut::observe(StockOutObserver::class);
    }
}
