<?php

namespace App\Traits;

use App\Models\AcReceiptDetail;
use App\Models\AcReceipt;
use App\Models\PaymentVoucher;
use App\Models\PaymentVoucherDetail;

trait TransactionSummeryTrait {
    public function transactionHistory($saleInvoiceId,$moduleCode)
    {
        $data=[];
        $AcReceipt = AcReceipt::where(['voucher_id' =>$saleInvoiceId, 'module_code' => $moduleCode])->get();
       
        foreach($AcReceipt as $key => $acr){
            $creditTransaction = AcReceiptDetail::with(['account','payment_mode'])
            ->where(['voucher_id' => $acr->id, 'transaction_type' => 'DEBIT'])
            ->get();
            $paymentModeName = '';
            foreach($creditTransaction as $key => $list){

                if(isset($list->payment_mode->mode) && $list->payment_mode->mode!=''){
                    $paymentModeName = $list->payment_mode->mode??'';
                }elseif(isset($list->account->name) && $list->account->name!=''){
                    $paymentModeName = $list->account->name??'';
                }

                $data[]=['transactionDate'  => isset($acr->receipt_date) && $acr->receipt_date != '' ? formatedDate($acr->receipt_date) : date('m/d/Y'),
                        'transactionMode'   => $list->account->name??'',
                        'id'                => $list->voucher_id??'',
                        'amount'            => convertDecimelPoint($list->amount),
                        'paymentMode'       => $paymentModeName??'',
                        'advanceReceived'   => $acr->advance_received,
                        'mr_number'         => $acr->receipt_no??''];
            }
        }

        return $data;
    }

    public function ReturnTransactionHistory($saleInvoiceId,$moduleCode)
    {
        $data=[];
        $AcReceipt = AcReceipt::where(['voucher_id' =>$saleInvoiceId, 'module_code' => $moduleCode])->get();
       
        // foreach($AcReceipt as $key => $acr){
        //     $creditTransaction = AcReceiptDetail::with(['account','payment_mode'])
        //     ->where(['voucher_id' => $acr->id, 'transaction_type' => 'DEBIT'])
        //     ->get();
        //     $paymentModeName = '';
        //     foreach($creditTransaction as $key => $list){

        //         if(isset($list->payment_mode->mode) && $list->payment_mode->mode!=''){
        //             $paymentModeName = $list->payment_mode->mode??'';
        //         }elseif(isset($list->account->name) && $list->account->name!=''){
        //             $paymentModeName = $list->account->name??'';
        //         }

        //         $data[]=['transactionDate'  => isset($list->transaction_date) && $list->transaction_date != '' ? formatedDate($list->transaction_date) : date('m/d/Y'),
        //                 'transactionMode'   => $list->account->name??'',
        //                 'id'                => $list->voucher_id??'',
        //                 'amount'            => convertDecimelPoint($list->amount),
        //                 'paymentMode'       => $paymentModeName??'',
        //                 'advanceReceived'   => $acr->advance_received ];
        //     }
        // }

        return $data;
    }


    public function PurchaseTransactionHistory($purchaseInvoiceId,$moduleCode)
    {
        $data=[];
        $paymentVoucher = PaymentVoucher::where(['voucher_id' =>$purchaseInvoiceId, 'module_code' => $moduleCode])->get();
       
        foreach($paymentVoucher as $key => $acr){
            $creditTransaction = PaymentVoucherDetail::with(['account','payment_mode'])
            ->where(['voucher_id' => $acr->id, 'transaction_type' => 'CREDIT'])
            ->get();
            $paymentModeName = '';
            foreach($creditTransaction as $key => $list){

                if(isset($list->payment_mode->mode) && $list->payment_mode->mode!=''){
                    $paymentModeName = $list->payment_mode->mode??'';
                }elseif(isset($list->account->name) && $list->account->name!=''){
                    $paymentModeName = $list->account->name??'';
                }

                $data[]=['transactionDate'  => isset($list->transaction_date) && $list->transaction_date != '' ? formatedDate($list->transaction_date) : date('m/d/Y'),
                        'transactionMode'   => $list->account->name??'',
                        'id'                => $list->voucher_id??'',
                        'amount'            => convertDecimelPoint($list->amount),
                        'paymentMode'       => $paymentModeName??'',
                        'advanceReceived'   => $acr->advance_received ];
            }
        }

        return $data;
    }


    public function transactionHistoryCredit($saleInvoiceId,$moduleCode)
    {
        $data=[];
        $AcReceipt = AcReceipt::where(['voucher_id' =>$saleInvoiceId, 'module_code' => $moduleCode])->get();
       
        foreach($AcReceipt as $key => $acr){
            $creditTransaction = AcReceiptDetail::with(['account','payment_mode'])
            ->where(['voucher_id' => $acr->id, 'transaction_type' => 'CREDIT'])
            ->get();
            $paymentModeName = '';
            foreach($creditTransaction as $key => $list){

                if(isset($list->payment_mode->mode) && $list->payment_mode->mode!=''){
                    $paymentModeName = $list->payment_mode->mode??'';
                }elseif(isset($list->account->name) && $list->account->name!=''){
                    $paymentModeName = $list->account->name??'';
                }

                $data[]=[
                        'amount'            => convertDecimelPoint($list->amount)];
            }
        }

        return $data;
    }

    public function ipdTransactionHistory1($patientId,$moduleCode)
    {
        $data=[];
        $creditTransaction = AcReceiptDetail::leftjoin('ac_receipts', 'ac_receipt_details.voucher_id', 'ac_receipts.id')
            ->where([
                'ac_receipt_details.account_id'       => $patientId,
                'ac_receipt_details.voucher_type'     => $moduleCode,
                'ac_receipt_details.transaction_type' => 'CREDIT'
            ])
            ->get();

            $paymentModeName = '';
            foreach($creditTransaction as $key => $list){

                if(isset($list->payment_mode->mode) && $list->payment_mode->mode!=''){
                    $paymentModeName = $list->payment_mode->mode??'';
                }elseif(isset($list->account->name) && $list->account->name!=''){
                    $paymentModeName = $list->account->name??'';
                }

                $data[]=['transactionDate'  => isset($list->transaction_date) && $list->transaction_date != '' ? formatedDate($list->transaction_date) : date('m/d/Y'),
                        'transactionMode'   => $list->account->name??'',
                        'id'                => $list->voucher_id??'',
                        'amount'            => convertDecimelPoint($list->amount),
                        'paymentMode'       => $paymentModeName??'',
                        'advanceReceived'   => $list->advance_received ];
            }

        return $data;
    }

    public function ipdTransactionHistory($saleInvoiceId,$moduleCode)
    {
        $data=[];
        $AcReceipt = AcReceipt::where(['voucher_id' =>$saleInvoiceId, 'module_code' => $moduleCode])->get();
       
        foreach($AcReceipt as $key => $acr){
            $creditTransaction = AcReceiptDetail::with(['account','payment_mode'])
            ->where(['voucher_id' => $acr->id, 'transaction_type' => 'DEBIT'])
            ->get();
            $paymentModeName = '';
            foreach($creditTransaction as $key => $list){

                if(isset($list->payment_mode->mode) && $list->payment_mode->mode!=''){
                    $paymentModeName = $list->payment_mode->mode??'';
                }elseif(isset($list->account->name) && $list->account->name!=''){
                    $paymentModeName = $list->account->name??'';
                }

                $data[]=['transactionDate'  => isset($list->transaction_date) && $list->transaction_date != '' ? formatedDate($list->transaction_date) : date('m/d/Y'),
                        'transactionMode'   => $list->account->name??'',
                        'id'                => $list->voucher_id??'',
                        'amount'            => convertDecimelPoint($list->amount),
                        'paymentMode'       => $paymentModeName??'',
                        'advanceReceived'   => $acr->advance_received ];
            }
        }

        return $data;
    }


    public function StockTransactionHistory($InvoiceId,$moduleCode)
    {
        $data=[];
        return $data;
    }
}
