<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('companies_license_type', function (Blueprint $table) {
            $table->id();
            $table->integer('company_id');
            $table->string('license_type_name',100)->nullable();
            $table->string('license_code')->nullable();
            $table->integer('license_status')->default(1)->comment('1 is eqaul active and 0 is deactive');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('companies_license_type');
    }
};
