<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('companies_license', function (Blueprint $table) {
            $table->id();
            $table->integer('company_id');
            $table->string('license_name')->nullable();
            $table->string('license_number')->nullable();
            $table->date('valid_from');
            $table->date('valid_upto');
            $table->integer('license_status')->default(1)->comment('1 is active and 0 is deactive');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('companies_license');
    }
};
