<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('companies_bank', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id');
            $table->string('account_holder_name',255)->nullable();
            $table->string('account_number',255)->nullable();
            $table->string('ifsc_code',255)->nullable();
            $table->string('bank_name',255)->nullable();
            $table->string('bank_branch',255)->nullable();
            $table->string('swift_code',255)->nullable();
            $table->string('upi_id',200)->nullable();
            $table->mediumText('upi_transaction_note')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('companies_bank');
    }
};
