<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->id();
            $table->string('name',255)->nullable();
            $table->string('email',255)->nullable();
            $table->string('branch_name',255)->nullable();
            $table->string('branch_code',255)->nullable();
            $table->string('office_type',255)->nullable();
            $table->string('mobile_number',255)->nullable();
            $table->string('phone_number',255)->nullable();
            $table->string('whatsapp_no',100)->nullable();
            $table->string('logo',255)->nullable();
            $table->string('aadhaar_number',255)->nullable();
            $table->string('gst_number',255)->nullable();
            $table->string('pan_number',255)->nullable();
            $table->string('cst_number',255)->nullable();
            $table->string('license_number',255)->nullable();
            $table->enum('status', ['0', '1'])->default('1');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('companies');
    }
};
