<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_stocks', function (Blueprint $table) {
            $table->id('stockid');
            $table->unsignedBigInteger('financial_id')->nullable();
            $table->unsignedBigInteger('invoice_id')->nullable();
            $table->string('stock_type',20)->nullable();
            $table->date('stock_item_date')->nullable();
            $table->integer('stock_item_id')->nullable();
            $table->decimal('stock_in',10,2)->nullable();
            $table->decimal('stock_out',10,2)->nullable();
            $table->integer('stock_item_price_id')->nullable();
            $table->integer('stock_item_attribute_id')->unsigned()->nullable();
            $table->unsignedBigInteger('stock_company_id')->nullable();
            $table->text('stock_status_info')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_stocks');
    }
};
