<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('menu_model_permissios', function (Blueprint $table) {
            $table->id();
            $table->string('menu_name',150)->nullable();
            $table->enum('status',['0','1'])->default('1')->comment('1 is active and 0 is deactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('menu_model_permissios');
    }
};
