<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('accounts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('master_type_id')->nullable();
            $table->unsignedBigInteger('master_category_id')->nullable();
            $table->unsignedBigInteger('chart_of_account_sub_type_id')->nullable();
            $table->foreignId('division_id')->nullable()->constrained('account_divisions');
            $table->foreignId('company_id')->nullable()->constrained();
            $table->foreignId('tax_register_category_id')->nullable()->constrained('tax_register_categories');
            $table->string('name')->nullable();
            $table->string('code')->nullable();
            $table->enum('settlement_type', ['BILL_TO_BILL', 'LEDGER'])->nullable();
            $table->enum('balance_type', ['DEBIT', 'CREDIT'])->nullable();
            $table->decimal('opening_balance', 9, 2)->nullable();
            $table->string('print_name')->nullable();
            $table->string('referred_by')->nullable();
            $table->decimal('credit_limit', 10, 2)->nullable();
            $table->boolean('status')->default(1);
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable();
            $table->bigInteger('deleted_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('accounts');
    }
};
