<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('account_banks', function (Blueprint $table) {
            $table->id();

            $table->foreignId('account_id')->nullable()->constrained();
            $table->string('account_name')->nullable();
            $table->string('bank_name')->nullable();
            $table->bigInteger('account_no')->nullable();
            $table->integer('ifsc_code')->nullable();
            $table->string('swift_code', 15)->nullable();
            $table->string('upi_id', 35)->nullable();
            $table->string('upi_payee_name', 35)->nullable();
            $table->string('branch_name')->nullable();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('account_banks');
    }
};
