<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('account_licenses', function (Blueprint $table) {
            $table->id();

            $table->foreignId('account_id')->nullable()->constrained();
            $table->unsignedBigInteger('license_type_id')->nullable();
            $table->mediumText('license_number')->nullable();
            $table->string('pan_no')->nullable();
            $table->string('vat_no')->nullable();
            $table->string('gst_no')->nullable();
            $table->string('cin_no')->nullable();
            $table->date('valid_from')->nullable();
            $table->date('valid_upto')->nullable();
            $table->boolean('status')->default(1);

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('account_licenses');
    }
};
