<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('account_attachments', function (Blueprint $table) {
            $table->id();

            $table->foreignId('account_id')->nullable()->constrained();
            $table->string('title')->nullable();
            $table->text('details')->nullable();
            $table->string('file_name')->nullable();
            $table->date('activation_date')->nullable();
            $table->date('renewal_date')->nullable();
            $table->date('expiry_date')->nullable();
            $table->boolean('status')->default(1);

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('account_attachments');
    }
};
