<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoice_serial_settings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('invoice_type_id')->nullable();
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('financial_year_id')->nullable();
            $table->unsignedBigInteger('company_to_follow')->nullable();
            $table->string('branch_wise_counter')->nullable();
            $table->string('overall_counter')->nullable();
            $table->string('serial_prefix')->nullable();
            $table->string('serial_postfix')->nullable();
            $table->integer('no_of_zeros')->nullable();
            $table->boolean('add_financial_year')->nullable();
            $table->boolean('add_branch_code')->nullable();
            $table->integer('show_overall_serial_no')->default(2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoice_serial_settings');
    }
};
