<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payment_modes', function (Blueprint $table) {
            $table->id();
            $table->string('mode', 50);
            $table->string('status', 15)->default('Active');
            $table->unsignedTinyInteger('is_default')->default(0);
            $table->decimal('priority')->default(0);
            $table->timestamps();
        });

        // Insert initial data
        // $this->insertInitialData();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_modes');
    }

    /**
     * Insert initial data into the payment_modes table.
     */
    // private function insertInitialData()
    // {
    //     $paymentModes = [
    //         ['mode' => 'Cash', 'status' => 'Active', 'is_default' => 1, 'priority' => 1],
    //         ['mode' => 'NEFT/RTGS', 'status' => 'Active', 'is_default' => 0, 'priority' => 2],
    //         ['mode' => 'Cheque', 'status' => 'Active', 'is_default' => 0, 'priority' => 3],
    //         ['mode' => 'UPI', 'status' => 'Active', 'is_default' => 0, 'priority' => 4],
    //         ['mode' => 'Payment Gateway', 'status' => 'Active', 'is_default' => 0, 'priority' => 5],
    //         ['mode' => 'Other', 'status' => 'Active', 'is_default' => 0, 'priority' => 6],
    //     ];

    //     DB::table('payment_modes')->insert($paymentModes);
    // }
};
