<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('blood_groups', function (Blueprint $table) {
            $table->id();
            $table->string('group', 10);
            $table->timestamps();
        });

        // Insert initial data
        $this->insertInitialData();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('blood_groups');
    }

    /**
     * Insert initial data into the blood_groups table.
     */
    private function insertInitialData()
    {
        $bloodGroups = [
            ['group' => 'O+'],
            ['group' => 'A+'],
            ['group' => 'B+'],
            ['group' => 'AB+'],
            ['group' => 'O-'],
            ['group' => 'A-'],
            ['group' => 'B-'],
            ['group' => 'AB-'],
        ];

        DB::table('blood_groups')->insert($bloodGroups);
    }
};
