<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('marital_statuses', function (Blueprint $table) {
            $table->id();
            $table->string('name', 20);
            $table->timestamps();
        });

        // Insert initial data
        $this->insertInitialData();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('marital_statuses');
    }

    /**
     * Insert initial data into the marital_statuses table.
     */
    private function insertInitialData()
    {
        $marital_statuses = [
            ['name' => 'Single'],
            ['name' => 'Married'],
            ['name' => 'Widowed'],
            ['name' => 'Divorced'],
            ['name' => 'Separated']
        ];

        DB::table('marital_statuses')->insert($marital_statuses);
    }
};
